	;**************************************************
	; Autore: Alessio Luffarelli
	; 
	; Web: www.alessioluffarelli.it
	; 
	; Nome Progetto: Tastiera
	;
	; Data: 9/5/2003
	;
	;**************************************************

		PROCESSOR 16F84
		RADIX DEC
		INCLUDE "P16F84.INC"
		ERRORLEVEL -302

		;Setup of PIC configuration flags
		;XT oscillator
		;Disable watch dog timer
		;Enable power up timer
		;Disable code protect

		__CONFIG 3FF1H

;----------------------------------------------------------------------------------------------
		ORG 0CH

		;Variabili del programma principale
		PulsantePremuto RES 1

		;Variabili per la subroutine di ritardo
		msDelayCounter RES 2
;----------------------------------------------------------------------------------------------

	;Reset Vector
	;Start point at CPU reset

		ORG 00H

		bsf STATUS,RP0

		movlw 00000000B		;RA0-RA3: uscite per 4 led
		movwf TRISA

		;IMPORTANTE: alle linee RB4-RB7 (colonne) collegare 4 resistenze di pull-up
		movlw 11110000B		;RB0-RB3: uscita (righe); RB4-RB7: ingressi (colonne)
		movwf TRISB

		bcf STATUS,RP0		

;--------------------------------------------------------------------------------------------

		;Inizio del programma

		clrf PORTA

		movlw b'11111111'
		movwf PORTB			;Disabilita scansione

	MainLoop

		movlw 40
		call msDelay			;Attende 40 millisecondi

		call LeggiTastiera		;Legge lo stato della tastiera..
		movwf PulsantePremuto		;..e lo salva dentro la variabile

		xorlw 0
		btfsc STATUS,2			;Se non  stato premuto niente..
		goto MainLoop			;..allora ricomincia da capo

		movf PulsantePremuto,W
		movwf PORTA			;Visualizza il tasto premuto

		movlw 200
		call msDelay
		movlw 200
		call msDelay			;Mantiene la visualizzazione per 400 ms...

		clrf PORTA			;... e poi la toglie

	AttendiRilascio

		call LeggiTastiera
		xorlw 0
		btfss STATUS,2
		goto AttendiRilascio		;Attende che il pulsante venga rilasciato

		goto MainLoop

		;Fine del programma

;--------------------------------------------------------------------------------------------

	;**********************************************************************
	; Delay subroutine
	;
	; W = Requested delay time in ms (clock = 4MHz)
	;**********************************************************************
	msDelay

		movwf msDelayCounter+1
		clrf msDelayCounter+0

		;1 ms (about) internal loop
	msDelayLoop

		nop
		decfsz msDelayCounter+0,F
		goto msDelayLoop
		nop

		decfsz msDelayCounter+1,F
		goto msDelayLoop

		return

;------------------------------------------------------------------------------------------------

	;**********************************************************************
	; Subroutine di scansione tastiera
	;
	; Torna W = 0 se nessun tasto premuto, altrimenti W = valore del tasto
	;**********************************************************************

	LeggiTastiera

		movlw b'11111110' 			;Abilito scansione riga 1
		movwf PORTB

		;clrwdt

		btfss PORTB,4 				;Test pulsante P1
		retlw .1
		btfss PORTB,5 				;Test pulsante P2
		retlw .2
		btfss PORTB,6 				;Test pulsante P3
		retlw .3
		btfss PORTB,7 				;Test pulsante P4
		retlw .4

		movlw b'11111101' 			;Abilito scansione riga 2
		movwf PORTB

		;clrwdt

		btfss PORTB,4 				;Test pulsante P5
		retlw .5
		btfss PORTB,5 				;Test pulsante P6
		retlw .6
		btfss PORTB,6 				;Test pulsante P7
		retlw .7
		btfss PORTB,7 				;Test pulsante P8
		retlw .8

		movlw b'11111011' 			;Abilito scansione riga 3
		movwf PORTB

		;clrwdt

		btfss PORTB,4 				;Test pulsante P9
		retlw .9
		btfss PORTB,5 				;Test pulsante P10
		retlw .10
		btfss PORTB,6 				;Test pulsante P11
		retlw .11
		btfss PORTB,7 				;Test pulsante P12
		retlw .12
		movlw b'11110111' 			;Abilito scansione riga 4
		movwf PORTB

		;clrwdt

		btfss PORTB,4 				;Test pulsante P13
		retlw .13
		btfss PORTB,5 				;Test pulsante P14
		retlw .14
		btfss PORTB,6 				;Test pulsante P15
		retlw .15
		btfss PORTB,7 				;Test pulsante P16
		retlw .16

		movlw b'11111111' 			;Disabilito scansione tastiera
		movwf PORTB

		retlw .0 				;Torna che nessun tasto  stato premuto

;----------------------------------------------------------------------------------------------

		END
